#!/bin/sh

# ****************************************************************************
# N-Agent Activation key setup script for Linux platform
# 
# Feng Qu 
#
# Copyright © 2021 N-able Solutions ULC and N-able Technologies Ltd. All rights reserved.
#
# No part of this software code and/or binary may be reproduced or transmitted
# via any means be they mechnical, electronic or otherwise.  This software may
# not be used under any circumstances without prior written permission by the
# author(s) and copyright holder(s).
#
# THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
# **************************************************************************** */

# Sample key = []

#
# N-Agent home directory
#
HOME=/home/nagent
HOMELIB=$HOME
if [ -f /etc/POS_ver ] || [ -f /etc/N-CHAOS_ver ] || [ -f /etc/THINK_ver ]; then
	HOME=/etc
	HOMELIB=/usr/lib/nagent
fi

#
# Header
#
echo -n -e "N-Agent Activation key setup script\n\n"

#
# Check if openssl is installed
#
CheckOpen=$( rpm -qa | grep -i openssl | head -1 )
if [ -z $CheckOpen ]; then
  echo -n -e "Openssl is not installed, not able to decode the base64 encrypted activation key.\n"
  exit 1
#else
#  echo -n -e "Openssl is installed.\n"
fi

#
# Prompt the user to enter activation key
#
echo -n "Please enter activation key: "
read KEY
echo $KEY > /tmp/EncryptedKey.$$

# In developemnt stage, read in uncrypted key, encrypted it and use the 
# encrypted key as the input
# For some reason, openssl works fine if both in/out are files
#echo $KEY > /tmp/UnEncryptedKey.$$
# Encrypted the key
#openssl enc -base64 -in /tmp/UnEncryptedKey.$$ -out /tmp/EncryptedKey.$$

# Decrypted the key
openssl enc -d -base64 -in /tmp/EncryptedKey.$$ -out /tmp/DecryptedKey.$$

DecryptedKey=$( cat /tmp/DecryptedKey.$$ )

#
# Remove tmp files
#
rm -f /tmp/*.$$

# Check the decrypted key
if [ -z $DecryptedKey ]; then
  echo -n -e "\nCan not decrypt the base64 encrypted activation key\n"
  exit 2
#else
#  echo -n -e "\nThe decrypted key is $DecryptedKey\n"
fi

EndPoints=$( echo -n $DecryptedKey | cut -d\| -f1 )
ApplianceID=$( echo -n $DecryptedKey | cut -d\| -f2 )
ApplianceType=$( echo -n $DecryptedKey | cut -d\| -f3 )
RegistrationToken=$( echo -n $DecryptedKey | cut -d\| -f4 )

#echo -n -e "EndPoints are $EndPoints\n"
#echo -n -e "ApplianceID is $ApplianceID\n"
#echo -n -e "ApplianceType is $ApplianceType\n"

#
# Validate function of AppID
#
ValidateAppID(){
  ANS=$(echo $1 | grep '^[0-9]*$')
  if [ -z $ANS ]; then
    return 1
  else
    if [ $ANS -gt 0 ]; then
      return 0
    else
      return 1
    fi
  fi
}

#
# Validate AppID
#
ValidateAppID $ApplianceID
if [ $? -ne 0 ]; then
  echo -n -e "Invalid ApplianceID=$ApplianceID\n"
  exit 3
#else
#  echo -n -e "Valid ApplianceID=$ApplianceID\n"
fi

#
# Validate function for ApplianceType
#
ValidateAppType(){
  case $1 in
    1) return 0;;
    *) return 1;;
  esac
}

#
# Validate AppType
#
ValidateAppType $ApplianceType
if [ $? -ne 0 ]; then
  echo -n -e "Invalid ApplianceType=$ApplianceType\n"
  exit 4
#else
#  echo -n -e "Valid ApplianceType=$ApplianceType\n"
fi

#
# Validate function for RegistrationToken
#
ValidateRegistrationToken(){
  if [ --n $1 ]; then
      return 0
    else
      return 1
  fi
}

#
# Validate RegistrationToken
#
ValidateRegistrationToken $RegistrationToken
if [ $? -ne 0 ]; then
  echo -n -e "Invalid RegistrationToken=$RegistrationToken\n"
  exit 5
fi


CONFIG_FILE=$HOME/nagent.conf
#CONFIG_FILE=./nagent.conf

#
# Create the MAIN section of the configuration file
#
cat <<EOF>$CONFIG_FILE
[main]
	logfilename=/var/log/n-central/nagent.log
	loglevel=1
	homedir=$HOMELIB
	thread_limitation=50
	poll_delay=1
	datablock_size=20
EOF

#
# SOAP section
#
echo "[soap]" >> $CONFIG_FILE

#
# Parse and validate the endpoints
#

#
# Set the field seperator to ','
#
OLDIFS=$IFS
IFS=,

#
# Get Protocol
#
GetProtocol(){
  RET=${1%%://*}
  if [ $RET == $1 ]; then
    #no protocol defined, use default 'http'
    RET="http"
  else
    if [ -n $RET ]; then
      RET=$( echo $RET | tr '[:upper:]' '[:lower:]')
    else 
      RET="http"
    fi
  fi
  echo $RET
}

#
# Validate Protocol
#
ValidateProtocol(){
  if [ $1 == 'http' ] || [ $1 == 'https' ]; then
    return 0
  else
    return 1
  fi
}

#
# Get Hostname
#
GetHostName(){
  #remove the possible protocol part
  RET=${1#*://}
  #remove the possible port part
  RET=${RET%:*}
  echo $RET
}

#
# Validate Hostname
#
ValidateHost(){
  ANS=$( echo $1 | grep '[0-9]*\.[0-9]*\.[0-9]*\.[0-9]*' )
  if [ -z $ANS ]; then
    #hostname
    ANS=$( host $1 | grep -i "not found" )
    if [ -z $ANS ]; then
      return 0
    else
      return 1
    fi
  else
    #ip address
    TMPIFS=$IFS
    IFS=.
    #make sure the ip address does not exceeds 3 digits
    for net in $ANS
    do
      if [ ${#net} -gt 3 ]; then
        IFS=$TMPIFS
        return 1
      fi
    done
    IFS=$TMPIFS
    return 0
  fi
}

#
# Get Port
#
GetPort(){
  #remove the possible protocol part
  TMP=${1#*://}
  #remove the possible host name part
  RET=${TMP#*:}
  if [ $RET == $TMP ]; then
    #no port
    echo ""
  else
    echo $RET
  fi
}

#
# Validate Port
#
ValidatePort(){
  ANS=$(echo $1 | grep '^[0-9]*$')
  if [ -z $ANS ]; then
    return 1
  else
    if [ 0 -lt $ANS ] && [ $ANS -lt 65536 ]; then
      return 0
    else
      return 1
    fi
  fi
}

counter=0
for endpoint in $EndPoints
do
#  echo -n -e "Endpoint[$counter] is $endpoint\n"

#save upto 2 endpoints
  if [ $counter -ge 2 ]; then
    break
  fi

#get and validate protocol
  Protocol=$(GetProtocol $endpoint)
  ValidateProtocol $Protocol
  if [ $? -ne 0 ]; then
    echo -n -e "Invalid Protocol[$counter]=$Protocol\n"
    exit 5
#  else
#    echo -n -e "Valid Protocol[$counter]=$Protocol\n"
  fi

#get and validate hostname
  HostName=$(GetHostName $endpoint)
  ValidateHost $HostName
  if [ $? -ne 0 ]; then
    echo -n -e "Invalid Host[$counter]=$HostName\n"
    exit 6
#  else
#    echo -n -e "Valid Host[$counter]=$HostName\n"
  fi

#get and validate port
  Port=$(GetPort $endpoint)
  if [ -z $Port ]; then
    #set the default port, 80 for http and 443 for https
    if [ $Protocol == "http" ]; then 
      Port=80
    else
      Port=443
    fi
  fi
  ValidatePort $Port
  if [ $? -ne 0 ]; then
    echo -n -e "Invalid Port[$counter]=$Port\n"
    exit 7
#  else
#    echo -n -e "Valid Port[$counter]=$Port\n"
  fi

  #write valid end points to conf file
  if [ $counter -eq 0 ]; then
    echo -n -e "\tprotocol=$Protocol\n" >> $CONFIG_FILE
    echo -n -e "\tserver=$HostName\n" >> $CONFIG_FILE
    echo -n -e "\tport=$Port\n\n" >> $CONFIG_FILE
  else
    echo -n -e "\tprotocol_$counter=$Protocol\n">> $CONFIG_FILE
    echo -n -e "\tserver_$counter=$HostName\n" >> $CONFIG_FILE
    echo -n -e "\tport_$counter=$Port\n\n" >> $CONFIG_FILE
  fi

  ((counter=$counter + 1))
done

echo -n -e "\tendpoint_size=$counter\n" >> $CONFIG_FILE
echo -n -e "\tapplianceid=$ApplianceID\n" >> $CONFIG_FILE
echo -n -e "\tServer_ro=no\n" >> $CONFIG_FILE
echo -n -e "\tProxy=\n" >> $$CONFIG_FILE
echo -n -e "\tregistrationtoken=$RegistrationToken\n" >> $CONFIG_FILE
IFS=$OLDIFS
#
# That's all, folks!
#
